/*****************************************************************
|
|    AP4 - Unknown Descriptor 
|
|    Copyright 2002 Gilles Boccon-Gibod & Julien Boeuf
|
|
|    This file is part of Bento4/AP4 (MP4 Atom Processing Library).
|
|    Unless you have obtained Bento4 under a difference license,
|    this version of Bento4 is Bento4|GPL.
|    Bento4|GPL is free software; you can redistribute it and/or modify
|    it under the terms of the GNU General Public License as published by
|    the Free Software Foundation; either version 2, or (at your option)
|    any later version.
|
|    Bento4|GPL is distributed in the hope that it will be useful,
|    but WITHOUT ANY WARRANTY; without even the implied warranty of
|    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|    GNU General Public License for more details.
|
|    You should have received a copy of the GNU General Public License
|    along with Bento4|GPL; see the file COPYING.  If not, write to the
|    Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
|    02111-1307, USA.
|
****************************************************************/

#ifndef _AP4_UNKNOWN_DESCRIPTOR_H_
#define _AP4_UNKNOWN_DESCRIPTOR_H_

/*----------------------------------------------------------------------
|       includes
+---------------------------------------------------------------------*/
#include "Ap4.h"
#include "Ap4ByteStream.h"
#include "Ap4List.h"
#include "Ap4DataBuffer.h"
#include "Ap4Descriptor.h"

/*----------------------------------------------------------------------
|       AP4_UnknownDescriptor
+---------------------------------------------------------------------*/
class AP4_UnknownDescriptor : public AP4_Descriptor 
{
public:
    // methods
    AP4_UnknownDescriptor(AP4_ByteStream& stream, 
                          unsigned char   tag,
                          AP4_Size        header_size,
                          AP4_Size        payload_size);
    virtual AP4_Result WriteFields(AP4_ByteStream& stream);
    
private:
    // members
    AP4_DataBuffer m_Data;
};


#endif // _AP4_UNKNOWN_DESCRIPTOR_H_
